# -*- coding: utf-8 -*-
"""
Created on Tue Oct 22 12:13:05 2013

@author: gurevics
"""

import numpy as np
import matplotlib.pyplot as plt


x=0  # initial condition: x(t=0)=1;
y=1
t=0
h1=0.05 
h2=0.025
h3=0.001
T1=20*pi


def euler2(t,x,y,h,Tend):
    while t<=Tend:
        dx=h*y
        dy=h*(-x)
        x=x+dx
        y=y+dy
        t=t+h
        plt.plot(t,x,'bo')
        plt.xlabel("t")
        plt.ylabel("x(t)")
        
def heun(t,x,y,h,Tend):
    while t<=Tend:
        c1=h*y
        d1=h*(-x)
        c2=h*(y-h*x)
        d2=-h*(x+h*y)
        x=x+(c1+c2)/2
        y=y+(d1+d2)/2
        t=t+h
        plt.plot(t,x,'ro')
        plt.xlabel("t")
        plt.ylabel("x(t)") 

                   
fig1 = plt.figure(1)   
euler2(0,0,1,h1,T1) # (t,x,y)=(0,1,)
euler2(0,0,1,h2,T1)
euler2(0,0,1,h3,T1)
heun(0,0,1,h1,T1)

#fig2 = plt.figure(2)   
#heun(0,0,1,h1,T1)

plt.show()    
