program lorenz
!Blatt 4 Aufgabe 2
!Jan Vormann
!Lorenzgleichungen
!x'=sigma*(y-x)
!y'=r*x-y-x*z
!z'=x*y-b*z
!Lösen mit Runge-Kutta Stufe 4
!Die Werte für x,y,z werden in 'lorenz.dat' geschrieben, die Return-Map in 'lormap.dat'
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
implicit none
real,allocatable,dimension(:) :: x,y,z !x=phi'',y=phi',z=phi
real :: T_m, h, pi,f_z,f_y,f_x,t
real :: k1,k2,k3,k4
real :: r,sigma,b
real :: z_max1,z_max2
integer :: i,N_max,maximum

sigma=10.
b=8./3.

T_m=5000.
print*,'Anzahl der Rechenschritte N: '
read*, N_max
h=T_m/float(N_max)
print*,'Schrittweite h= ',h

allocate(x(0:N_max))
allocate(y(0:N_max))
allocate(z(0:N_max))



print*,'Startwert x?'
read*,x(0)
print*,'Startwert y?'
read*,y(0)
print*,'Startwert z?'
read*,z(0)
print*,'Rel. Rayleighzahl r?'
read*,r

t=0.

open(10,file='lorenz.dat')
write(10,*) '#N=',N_max,'  x_0=',x(0),'  y_0=',y(0),'  z_0=',z(0)
write(10,*) '#r=',r,' sigma=',sigma,' b=',b
write(10,*) t,'	',x(0),'	',y(0),'	',z(0)
print*,'Berechnung startet.'
!Werte mit RK4 berechnen
do i=1,N_max
 t=t+h
 !x
 k1=f_x(x(i-1),y(i-1))
 k2=f_x(x(i-1)+(h/2.)*k1,y(i-1))
 k3=f_x(x(i-1)+(h/2.)*k2,y(i-1))
 k4=f_x(x(i-1)+h*k3,y(i-1))
 x(i)=x(i-1)+(h/6.)*(k1+2.*k2+2.*k3+k4)
 !y
 k1=f_y(x(i),y(i-1),z(i-1),r)
 k2=f_y(x(i),y(i-1)+(h/2.)*k1,z(i-1),r)
 k3=f_y(x(i),y(i-1)+(h/2.)*k2,z(i-1),r)
 k4=f_y(x(i),y(i-1)+h*k3,z(i-1),r)
 y(i)=y(i-1)+(h/6.)*(k1+2.*k2+2.*k3+k4)
 !z
 k1=f_z(x(i),y(i),z(i-1))
 k2=f_z(x(i),y(i),z(i-1)+(h/2.)*k1)
 k3=f_z(x(i),y(i),z(i-1)+(h/2.)*k2)
 k4=f_z(x(i),y(i),z(i-1)+h*k3)
 z(i)=z(i-1)+(h/6.)*(k1+2.*k2+2.*k3+k4)
 write(10,*) t,'	',x(i),'	',y(i),'	',z(i)
enddo

close(10)
print*,'Berechnung beendet.'

open(10,file='lormap.dat')
write(10,*) '#N=',N_max,'  x_0=',x(0),'  y_0',y(0),'  x_0=',x(0)
write(10,*) '#r=',r,' sigma=',sigma,' b=',b
deallocate(x)
deallocate(y)

!Maxima suchen
!Maxima treten auf für y=0 und z<0
i=1
maximum=1.
do while (maximum .ge. 0)
 if ((z(i-1)<z(i)) .and. (z(i+1)<z(i))) then
  z_max1=z(i)
  maximum=1
  i=i+1
  if (i==N_max) maximum=-1
  do while (maximum==1)
   if ((z(i-1)<z(i)) .and. (z(i+1)<z(i))) then
    z_max2=z(i)
    maximum=0
    write(10,*) z_max1,'	',z_max2
   endif
   i=i+1
   if (i==N_max) maximum=-1
  enddo
 
 endif
i=i+1
if (i==N_max) maximum=-1
enddo

end program

real function f_z(x,y,z)
implicit none
real :: b
real :: x,y,z
b=8./3.
f_z=x*y-b*z
return
end

real function f_x(x,y)
implicit none
real :: sigma
real :: x,y
sigma=10.
f_x=sigma*(y-x)
return
end

real function f_y(x,y,z,r)
implicit none
real :: x,y,z,r
f_y=r*x-y-x*z
return
end


