program pohlrad
!Blatt 4 Aufgabe 1
!Jan Vormann
!Pohlsches Rad
!J*phi''+K*phi'+D*phi-N*sin(phi)=F*sin(wt)
!
!Lösen mit Runge-Kutta Stufe 4
!Die Werte für phi werden in 'pohl.dat' geschrieben, die Return-Map in 'return.dat'
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
implicit none
real,allocatable,dimension(:) :: x,y !x=phi,y=phi'
real :: T_m, h, pi,f_z,f_y,t
real :: k1,k2,k3,k4
real :: D,N,F,K,w
real :: phi_max1,phi_max2
integer :: i,N_max,maximum

pi=4.0*atan(1.)
D=9.44
K=0.799
N=14.68
F=2.1
T_m=500.
print*,'Anzahl der Rechenschritte N: '
read*, N_max
h=T_m/float(N_max)
print*,'Schrittweite h= ',h

allocate(x(0:N_max))
allocate(y(0:N_max))




print*,'Startwert phi?'
read*,x(0)
print*,'Startwert d phi/dt?'
read*,y(0)
print*,'Antriebsfrequenz omega?'
read*,w

t=0.

open(10,file='pohl.dat')
write(10,*) '#N=',N_max,'  phi_0=',x(0),'  dphi/dt_0=',y(0),'  Omega=',w
write(10,*) t,'	',x(0),'	',y(0)

!Werte mit RK4 berechnen
do i=1,N_max
 t=t+h
 !y
 k1=f_y(x(i-1),y(i-1),t,w)
 k2=f_y(x(i-1),y(i-1)+(h/2.)*k1,t,w)
 k3=f_y(x(i-1),y(i-1)+(h/2.)*k2,t,w)
 k4=f_y(x(i-1),y(i-1)+h*k3,t,w)
 y(i)=y(i-1)+(h/6.)*(k1+2.*k2+2.*k3+k4)
 !x
 x(i)=x(i-1)+h*y(i)
 write(10,*) t,'	',x(i),'	',y(i)
enddo

close(10)


open(10,file='return.dat')
write(10,*) '#N=',N_max,'  phi_0=',x(0),'  dphi/dt_0=',y(0),'  Omega=',w


!Maxima suchen
!
i=1
maximum=1.
do while (maximum .ge. 0)
 if ((x(i-1)< x(i)) .and. (x(i+1) < x(i))) then
  phi_max1=x(i)
  maximum=1
  i=i+1
  do while (maximum==1)
   if ((x(i-1)< x(i)) .and. (x(i+1) < x(i))) then
    phi_max2=x(i)
    maximum=0
    write(10,*) phi_max1,'	',phi_max2
   endif
   i=i+1
   if (i==N_max) maximum=-1
  enddo
 
 endif
i=i+1
if (i==N_max) maximum=-1
enddo

end program



real function f_y(x,y,t,w)
implicit none
real :: D,N,F,K
real :: x,y,z,t,w
D=9.44
K=0.799
N=14.68
F=2.1
f_y=-K*y-D*x+N*sin(x)+F*sin(w*t)
return
end


