	PROGRAM pohl

C********************************************************
C	Solves the ordinary differential equation of pohl's
C       pendulum with runge-kutta 4
C       Plot in Dislin
C       Compile with dlink -c pohl
C********************************************************
	PARAMETER(T=100.,DT=0.01,IDIM=T/DT)
	PARAMETER(a=14.68,b=9.44,c=0.799,d=2.1,e=2.3)	
	DIMENSION XARAY(IDIM),YARAY(IDIM),ZARAY(IDIM),YMAX(IDIM)
	DIMENSION XK(4),YK(4),ZK(4)
 	INTEGER MAXCOUNT
	REAL MAXIMUM

C       Initialize Dislin

	CALL METAFL('XWIN')
        CALL X11MOD('STORE')
	
        CALL WINSIZ(603,603)

        CALL SCRMOD('REVERS')
	CALL DISINI
  
	CALL AXSPOS(450,1800)
        CALL AXSLEN(2200,1200)  
C       CALL BUFMOD('OFF','SENDBF')
        
        CALL COLOR('FORE')
        CALL GRAF(-4.,4.,-4.,1.,-4.,4.,-4.,1.)	
 	  
        CALL PAGERA
        CALL COMPLX
  
        CALL NAME('X-axis','X')
        CALL NAME('Y-axis','Y')

        
        CALL HEIGHT(50)
        CALL TITLE

	Write(6,*) 'Gib x(t=0) und y(t=0) ein'

C       Initial value of X
	Write(6,*) 'Initial value of X and Y'
	READ(5,*) X
	READ(5,*) Y
	Z=0.
	MAXCOUNT=0
	
C       Calculating the K-Values for Runge-Kutta
	DO I=1, IDIM
	 XHILF=X
	 YARAY(I)=Y
	 YHILF=Y
	 ZHILF=Z
	 DO L=1, 4   
          XK(L)=0.
          YK(L)=0.
	  ZK(L)=0.
         ENDDO
	 XK(1)=XK(1)+FUNCX(X,Y,Z)*DT
	 YK(1)=YK(1)+FUNCY(X,Y,Z,a,b,c,d,e)*DT
	 ZK(1)=ZK(1)+FUNCZ(X,Y,Z)*DT

	 XK(2)=XK(2)+FUNCX(X+0.5*XK(1),Y+0.5*YK(1),Z+0.5*ZK(1))*DT
	 YK(2)=YK(2)+FUNCY(X+0.5*YK(1),Y+0.5*YK(1),
     &         Z+0.5*ZK(1),a,b,c,d,e)*DT
	 ZK(2)=ZK(2)+FUNCZ(X+0.5*YK(1),Y+0.5*YK(1),Z+0.5*ZK(1))*DT

	 XK(3)=XK(3)+FUNCX(X+0.5*XK(2),Y+0.5*YK(2),Z+0.5*ZK(2))*DT
	 YK(3)=YK(3)+FUNCY(X+0.5*XK(2),Y+0.5*YK(2),
     &         Z+0.5*ZK(2),a,b,c,d,e)*DT
	 ZK(3)=ZK(3)+FUNCZ(X+0.5*XK(2),Y+0.5*YK(2),Z+0.5*ZK(2))*DT

	 XK(4)=XK(4)+FUNCX(X+XK(3),Y+YK(3),Z+ZK(3))*DT
	 YK(4)=YK(4)+FUNCY(X+XK(3),Y+YK(3),
     &         Z+ZK(3),a,b,c,d,e)*DT
	 ZK(4)=ZK(4)+FUNCZ(X+XK(3),Y+YK(3),Z+ZK(3))*DT
            

	 X=X+(XK(1)+2.*XK(2)+2.*XK(3)+XK(4))/6.
	 Y=Y+(YK(1)+2.*YK(2)+2.*YK(3)+YK(4))/6.
	 Z=Z+(ZK(1)+2.*ZK(2)+2.*ZK(3)+ZK(4))/6.


C        Determining the Maxima

	 IF(Y < 0. .AND. YHILF >0.) THEN
	  MAXCOUNT=MAXCOUNT+1
	 ENDIF

	 IF(Y > 0.) THEN
	  MAXIMUM=MAX(Y,YMAX(MAXCOUNT))
	  YMAX(MAXCOUNT)=MAXIMUM
C	  WRITE(6,*) YMAX(MAXCOUNT)
	 ENDIF

C        PLOTS A PHASE PORTRAIT
	 CALL PLOT(X,Y,XHILF,YHILF)
	
	ENDDO	
	CALL DISFIN

C       Plot of the RETURN-Map
	CALL PLOTMAX(YMAX,MAXCOUNT)       	

	STOP
	END

C****************************************

	REAL FUNCTION FUNCX(X,Y,Z)
	
	FUNCX=Y
	RETURN 
	END 

C****************************************

	REAL FUNCTION FUNCY(X,Y,Z,a,b,c,d,e)
	
	FUNCY=-c*Y-b*X+a*SIN(X)+d*SIN(e*Z)
	RETURN 
	END 

C****************************************

	REAL FUNCTION FUNCZ(X,Y,Z)
	
	FUNCZ=1.
	RETURN 
	END 

C****************************************

C	X-Y Diagramm

       SUBROUTINE PLOT(X,Y,XHILF,YHILF)
	
		
       DIMENSION XA(2), YA(2)

       CALL COLOR('FORE') 
       CALL HEIGHT(50)
       CALL TITLE
       XA(1)=XHILF
       XA(2)=X
       YA(1)=YHILF
       YA(2)=Y	

   
       CALL COLOR('BLUE')
       CALL CURVE(XA, YA,2)
       
C       CALL COLOR('FORE')
C       CALL LEGINI(CA,3,10)
C       CALL LEGTIT(' ')
C       CALL LEGLIN(CA,'HEUN',1)
C       CALL LEGLIN(CA,'R-K 4',2)
C       CALL LEGLIN(CA,'EXACT',3)
C       CALL LEGEND(CA,8)
	CALL SENDBF
   
       RETURN
       END

C******************************************
      SUBROUTINE PLOTMAX(YMAX,MAXCOUNT)
		
      DIMENSION YMAX(MAXCOUNT),YPLUS(MAXCOUNT-1),Y(MAXCOUNT-1)
      
      CALL METAFL('XWIN')
      CALL DISINI
      CALL PAGERA
      CALL COMPLX

      CALL AXSPOS(450,1800)
      CALL AXSLEN(2200,1200)

      CALL NAME('Y(n)-axis','X')
      CALL NAME('Y(n+1)-axis','Y')

      CALL GRAF(2.2,2.6,2.2,0.1,2.2,2.6,2.2,0.1)
     

      CALL COLOR('FORE') 
      CALL HEIGHT(50)
 
      DO I=1 , MAXCOUNT-1
	YPLUS(I)=YMAX(I+1)
	Y(I)=YMAX(I)
	WRITE(6,*) I
      	WRITE(6,*) YPLUS(I)
	WRITE(6,*) Y(I)
      ENDDO
      CALL COLOR('RED')
      CALL INCMRK(-1)
      CALL MARKER(2)
      CALL HSYMBL(4)
      CALL CURVE(YMAX,YPLUS,MAXCOUNT-1)
      CALL DISFIN
      
      RETURN
      END

