	PROGRAM lorenz

C********************************************************
C	Solves the ordinary differential lorenz equations
C       with runge-kutta 4
C       Plot in Dislin
C       Compile with dlink -c lorenz
C********************************************************
	PARAMETER(T=100.,DT=0.01,IDIM=T/DT)
	PARAMETER(r=25.,SIGMA=10.,b=8./3.)	
	DIMENSION XARAY(IDIM),YARAY(IDIM),ZARAY(IDIM),ZMAX(IDIM)
	DIMENSION XK(4),YK(4),ZK(4)
 	INTEGER MAXCOUNT
	REAL MAXIMUM

C       Initialize Dislin

	CALL METAFL('XWIN')
        CALL X11MOD('STORE')
	
        CALL WINSIZ(603,603)

        CALL SCRMOD('REVERS')
	CALL DISINI
  
	CALL AXSPOS(450,1800)
        CALL AXSLEN(2200,1200)  
C       CALL BUFMOD('OFF','SENDBF')
        
        CALL COLOR('FORE')
        CALL GRAF(-30.,30.,-30.,10.,-30.,30.,-30.,10.)	
 	  
        CALL PAGERA
        CALL COMPLX
  
        CALL NAME('X-axis','X')
        CALL NAME('Y-axis','Y')

        
        CALL HEIGHT(50)
        CALL TITLE

	Write(6,*) 'Gib x(t=0) und y(t=0) und z(t=0) ein'

C       Initial value of X
	Write(6,*) 'Initial value of X,Y and Z'
	READ(5,*) X
	READ(5,*) Y
	READ(5,*) Z
	MAXCOUNT=0
	
C       Calculating the K-Values for Runge-Kutta
	DO I=1, IDIM
	 XHILF=X
	 YARAY(I)=Y
	 WRITE(6,*) Z
	 YHILF=Y
	 ZHILF=Z
	 DO L=1, 4   
          XK(L)=0.
          YK(L)=0.
	  ZK(L)=0.
         ENDDO
	 XK(1)=XK(1)+FUNCX(X,Y,Z,SIGMA)*DT
	 YK(1)=YK(1)+FUNCY(X,Y,Z,r)*DT
	 ZK(1)=ZK(1)+FUNCZ(X,Y,Z,b)*DT

	 XK(2)=XK(2)+FUNCX(X+0.5*XK(1),Y+0.5*YK(1),Z+0.5*ZK(1),SIGMA)*DT
	 YK(2)=YK(2)+FUNCY(X+0.5*YK(1),Y+0.5*YK(1),
     &         Z+0.5*ZK(1),r)*DT
	 ZK(2)=ZK(2)+FUNCZ(X+0.5*YK(1),Y+0.5*YK(1),Z+0.5*ZK(1),b)*DT

	 XK(3)=XK(3)+FUNCX(X+0.5*XK(2),Y+0.5*YK(2),Z+0.5*ZK(2),SIGMA)*DT
	 YK(3)=YK(3)+FUNCY(X+0.5*XK(2),Y+0.5*YK(2),
     &         Z+0.5*ZK(2),r)*DT
	 ZK(3)=ZK(3)+FUNCZ(X+0.5*XK(2),Y+0.5*YK(2),Z+0.5*ZK(2),b)*DT

	 XK(4)=XK(4)+FUNCX(X+XK(3),Y+YK(3),Z+ZK(3),SIGMA)*DT
	 YK(4)=YK(4)+FUNCY(X+XK(3),Y+YK(3),
     &         Z+ZK(3),r)*DT
	 ZK(4)=ZK(4)+FUNCZ(X+XK(3),Y+YK(3),Z+ZK(3),b)*DT
            

	 X=X+(XK(1)+2.*XK(2)+2.*XK(3)+XK(4))/6.
	 Y=Y+(YK(1)+2.*YK(2)+2.*YK(3)+YK(4))/6.
	 Z=Z+(ZK(1)+2.*ZK(2)+2.*ZK(3)+ZK(4))/6.


C        Determining the Maxima, with Poincaré Schnitt at Z=20.

	 IF(Z < 20. .AND. ZHILF >20.) THEN
	  MAXCOUNT=MAXCOUNT+1
	 ENDIF

	 IF(Z > 20.) THEN
	  MAXIMUM=MAX(Z,ZMAX(MAXCOUNT))
	  ZMAX(MAXCOUNT)=MAXIMUM
	  WRITE(6,*) ZMAX(MAXCOUNT)
	 ENDIF

C        PLOTS A PHASE PORTRAIT
	 CALL PLOT(X,Y,XHILF,YHILF)
	
	ENDDO	
	CALL DISFIN

C       Plot of the RETURN-Map
	CALL PLOTMAX(ZMAX,MAXCOUNT)       	

	STOP
	END

C****************************************

	REAL FUNCTION FUNCX(X,Y,Z,SIGMA)
	
	FUNCX=SIGMA*(Y-X)
	RETURN 
	END 

C****************************************

	REAL FUNCTION FUNCY(X,Y,Z,r)
	
	FUNCY=r*X-Y-X*Z
	RETURN 
	END 

C****************************************

	REAL FUNCTION FUNCZ(X,Y,Z,b)
	
	FUNCZ=X*Y-B*Z
	RETURN 
	END 

C****************************************

C	X-Y Diagramm

       SUBROUTINE PLOT(X,Y,XHILF,YHILF)
	
		
       DIMENSION XA(2), YA(2)

       CALL COLOR('FORE') 
       CALL HEIGHT(50)
       CALL TITLE
       XA(1)=XHILF
       XA(2)=X
       YA(1)=YHILF
       YA(2)=Y	

   
       CALL COLOR('BLUE')
       CALL CURVE(XA, YA,2)
       
C       CALL COLOR('FORE')
C       CALL LEGINI(CA,3,10)
C       CALL LEGTIT(' ')
C       CALL LEGLIN(CA,'HEUN',1)
C       CALL LEGLIN(CA,'R-K 4',2)
C       CALL LEGLIN(CA,'EXACT',3)
C       CALL LEGEND(CA,8)
	CALL SENDBF
   
       RETURN
       END

C******************************************
      SUBROUTINE PLOTMAX(ZMAX,MAXCOUNT)
		
      DIMENSION ZMAX(MAXCOUNT),ZPLUS(MAXCOUNT-1),Z(MAXCOUNT-1)
      
      CALL METAFL('XWIN')
      CALL DISINI
      CALL PAGERA
      CALL COMPLX

      CALL AXSPOS(450,1800)
      CALL AXSLEN(2200,1200)

      CALL NAME('Z(n)-axis','X')
      CALL NAME('Z(n+1)-axis','Y')

      CALL GRAF(27.,40.,27.,1.,27.,40.,27.,1.)
     

      CALL COLOR('FORE') 
      CALL HEIGHT(50)
 
      DO I=1 , MAXCOUNT-1
	ZPLUS(I)=ZMAX(I+1)
	Z(I)=ZMAX(I)
	WRITE(6,*) I
      	WRITE(6,*) ZPLUS(I)
	WRITE(6,*) Z(I)
      ENDDO
      CALL COLOR('RED')
      CALL INCMRK(-1)
      CALL MARKER(2)
      CALL HSYMBL(4)
      CALL CURVE(ZMAX,ZPLUS,MAXCOUNT-1)
      CALL DISFIN
      
      RETURN
      END

