clear all
close all
%-------------------
% Solution of Boundary Value Problem with the shooting method.
% Equation to solve:
% x''=a*x^2 with a=1,5 on
% the interval [0,1] 
% Boundary conditions are: x(0)=4; x(1)=1;
%--------------------
global a b b1 b2 h
 k=-100;
 M=100;
 j=1;
 a=0;
 b=1;
 b1=4;
 b2=1;
 h=0.01;
 %----------------
for i=1:M
R=rk4s('qwe','qwe1',a,b,b1,k,h);
w(i)=R(size(R,1),2)-b2;
k=k+1;
 end;
 %--------------------
 
 t=-100:1:-0.5;
 figure(1)
 plot(t,w,'r','Linewidth',2)
 hold on
 plot(t,0,'k')
 xlabel('t','FontName','Times New Roman','FontSize',16)
 ylabel('F(t,s)-1','FontName','Times New Roman','FontSize',16)
 %--------------------
 k=-100;
 l=1;
 for i=1:M-1
     if ((w(i)<0) & (w(i+1)>0)) | ((w(i)>0) & (w(i+1)<0))
         s0(l)=k;
         l=l+1;
     end;
      k=k+1;
 end;
 %--------------------
 ds=0.01;
 delta=0.01;
 K=100;
 for j=1:size(s0,2)
sr(j)=nrm(w,s0(j),ds,K,delta);
plot(sr(j),0,'-bo','MarkerEdgeColor','r',...
                'MarkerFaceColor','g',...
                'MarkerSize',10)
 end;
%---------------------
sr
%----------------------
figure(2)
 R1=rk4s('qwe','qwe1',0,1,4,sr(1),0.01);
 plot(R1(:,1),R1(:,2),'r','Linewidth',2)
 hold on
 R2=rk4s('qwe','qwe1',0,1,4,sr(2),0.01);
 plot(R2(:,1),R2(:,2),'b','Linewidth',2)
 xlabel('t','FontName','Times New Roman','FontSize',16)
 ylabel('x','FontName','Times New Roman','FontSize',16)
 %-----------------------
 