	PROGRAM LAX

!****************************************************
!	Solves the advection equation with the Lax
!	method
!	Compile with dlink -c lax
!****************************************************
	
	PARAMETER (X_LENGTH=10.,DX=0.01,IDM=INT(X_LENGTH/DX),
     &             T=100.,DT=0.01,IDIM=T/DT)
	INTEGER I,SEED,N,TILDEI
	INTEGER plan_forw(8),plan_back(8)
	REAL C_VELOCITY
	DIMENSION UARAY(IDM),EXACT(IDM)
	DIMENSION XARAY(IDM),UNULL(IDM)

	C_VELOCITY=0.5
	PI=2.*ASIN(1.)
	N=IDM
!       Dislin Initialisation

        CALL METAFL('XWIN')
        CALL X11MOD('STORE')
	
        CALL WINSIZ(603,603)

        CALL SCRMOD('REVERS')
	CALL DISINI
	
!	Initial conditions for U
	
	DO I=1, N
	 XARAY(I)=REAL(X_LENGTH*(I-1)/IDM)
	 UARAY(I)=EXP(-10.*(XARAY(I)-5.)**2)
	 UNULL(I)=UARAY(I)
	ENDDO
	 
!       Time Iteration

	DO J=1, IDIM
!	 Dislin Axis System

	 CALL ENDGRF
	 CALL BUFMOD('OFF','SENDBF')
         CALL AXSPOS(450,1800)
         CALL AXSLEN(2200,1600)  
         CALL COLOR('FORE')
         CALL GRAF(0.,10.,0.,1.,-1.,2.,-1.,0.5)	
         CALL PAGERA
         CALL COMPLX
  
         CALL NAME('X-axis','X')
         CALL NAME('Y-axis','Y')

        
         CALL HEIGHT(50)
         CALL TITLE

	 CALL ITERATE(UARAY,N,DT,DX,C_VELOCITY)

!        Calculating the exact solution
	 DO I=1, N-1
	  TILDEI=INT(N*(XARAY(I)-C_VELOCITY*T*J/IDIM)/X_LENGTH)-2
!	  Periodic boundary conditions for the exact solution
	  IF(TILDEI .LE. 1) THEN
	   TILDEI=MOD(ABS(TILDEI),N)
	   IF(TILDEI .EQ. 0) THEN
	    TILDEI=1
	   ENDIF
          ENDIF
       	  EXACT(I)=UNULL(TILDEI)
         ENDDO
	 CALL PLOT(XARAY,UARAY,EXACT,N)

	ENDDO

	STOP 
	END


C********************************************************************
	
	SUBROUTINE ITERATE(UARAY,N,DT,DX,C_VELOCITY)
	
	INTEGER N
	DIMENSION UARAY(N),TUARAY(N)
	REAL DT,DX,C_VELOCITY
	
!       Saving the old values of UARAY
	DO I=1, N
	 TUARAY(I)=UARAY(I)
	ENDDO
!	Periodic Boundary Conditions LEFT END
	UARAY(1)=(TUARAY(2)+TUARAY(N))/2.-C_VELOCITY*DT*
     &           (TUARAY(2)-TUARAY(N))/(2.*DX)

	DO I=2, N-1
    	 UARAY(I)=(TUARAY(I+1)+TUARAY(I-1))/2.-C_VELOCITY*DT*
     &            (TUARAY(I+1)-TUARAY(I-1))/(2.*DX)
        ENDDO

!	Periodic Boundary Conditions RIGHT END
	UARAY(N)=(TUARAY(1)+TUARAY(N-1))/2.-C_VELOCITY*DT*
     &           (TUARAY(1)-TUARAY(N-1))/(2.*DX)
	RETURN
	END  

C**************************************************************
      SUBROUTINE PLOT(XARAY,UARAY,EXACT,N)
      
      DIMENSION XARAY(N),UARAY(N),EXACT(N)
      CALL COLOR('BLUE')
      CALL CURVE(XARAY,UARAY,N) 
      CALL COLOR('RED')
      CALL CURVE(XARAY,EXACT,N) 
C     CLEANING THE SCREEN
      CALL SENDBF
      CALL ERASE



      
 	
 
     
      
      RETURN
      END
