function u = smooth(u,nu,F,h,N,mode,w) 
%Iteration zur Lsung der 2D Poisson-Gleichung: u_xxyy = F mit
%Anfangs-Randwertbedingungen
%
% u(i,j) entspricht u(x,y), dim(uin) = NxN
% nu: Anzahl Iterationsschritte
% h: Schrittweite
% F(i,j) entspricht F(x,y), dim(uin) = NxN 
% falls mode=jac, wird der relaxationsparameter w bercksichtigt
if mode == 'jac'
    for k = 1:nu
        uold = u;
        for i = 2:N-1
            for j = 2:N-1
                u(i,j)=uold(i,j)+w*(0.25*(-h^2* F(i,j) + uold(i-1,j)+uold(i+1,j)+uold(i,j-1)+uold(i,j+1))-uold(i,j) );
            end;
        end;
    end;
elseif mode =='gle'
    for k = 1:nu
        uold = u;
        for i = 2:N-1
            for j = 2:N-1
                u(i,j)=0.25*(-h^2* F(i,j) + u(i-1,j)+uold(i+1,j)+u(i,j-1)+uold(i,j+1));
            end;
        end;
    end;
elseif mode =='grb'
    for k = 1:nu
        uold = u;
        for i = 2:N-1
            for j = 2:N-1
                if xor(mod(i,2),mod(j,2))==0
                    u(i,j)=0.25*(-h^2* F(i,j) + uold(i-1,j)+uold(i+1,j)+uold(i,j-1)+uold(i,j+1));
                end;
            end;
        end;    
        for i = 2:N-1
            for j = 2:N-1
                if xor(mod(i,2),mod(j,2))
                    u(i,j)=0.25*(-h^2* F(i,j) + u(i-1,j)+u(i+1,j)+u(i,j-1)+u(i,j+1));
                end;
            end;
        end;
    end;
end;
return;