# -*- coding: utf-8 -*-
"""
Created on Wed Jun  4 16:07:05 2014

@author: gurevics
"""

# -*- coding: utf-8 -*-



import numpy as np
import matplotlib.pyplot as plt


Lx = 128#Physikalische Länge des Gebietes in x-Richtung
Ly = 128#Physikalische Länge des Gebietes in y-Richtung
Nx = 128# Anzahl Diskretisierungspunkte in x-Richtung
Ny = 128# Anzahl Diskretisierungspunkte in y-Richtung

# Für die Maske
dr=3 # dr=1-Kreis
radius=110 
#
x, y = np.meshgrid(np.arange(Nx) * Lx/Nx,np.arange(Ny) * Ly/Ny) #x-Array
kx, ky = np.meshgrid(np.fft.fftfreq(Nx,Lx/(Nx*2.0*np.pi)), np.fft.fftfreq(Ny,Ly/(Ny*2.0*np.pi)))

#
ksq = kx*kx + ky*ky
#
c = 0.0+(np.random.random((Nx,Ny))-0.5)*0.1
#c = np.sin(np.sqrt((x-Lx/2)**2+(y-Ly/2)**2)*1.5)+(np.random.random((Nx,Ny))-0.5)*0.1 

# eps=0.3, delta=0  - Streifen; eps=0.1, delta=1.0- Hexagone
eps= 0.3
delta=0.0

t = 0.0
dt = 0.03
T_End = 1000
N_t = int(T_End / dt)

plotEveryNth = 200
#
ck = np.fft.fft2(c)
#
def rhs_lin(ksq):
    result=eps-(1.0-ksq)**2
    return result
    
Eu=1.0/(1.0-dt*rhs_lin(ksq))

#Definiere die Maske....
mx = np.fft.fftshift(kx)
my = np.fft.fftshift(ky)
mx = mx/np.max(mx)*Lx
my = my/np.max(my)*Ly
rad = np.sqrt(mx**2+dr*my**2)
mask = rad>radius
mask =np.float64(mask)*(-3*eps)
#
#plt.figure()
#plt.imshow(mask)
#plt.show()

#       
for i in range(N_t):
    ck=Eu*(ck+dt*(np.fft.fft2(mask*c)+delta*np.fft.fft2(np.fft.ifft2(ck)**2)-np.fft.fft2(np.fft.ifft2(ck)**3)))
    c=np.fft.ifft2(ck)
    if(i % plotEveryNth == 0):
        print("Step %04d" %(i/plotEveryNth))
        plt.cla()
        plt.contourf(x,y,c.real,50,cmap=plt.cm.jet,vmin=-0.8,vmax=0.8)
        cb=plt.colorbar()
        cb.ax.tick_params(labelsize=16)
        plt.ylabel("y",fontsize=18)
        plt.xlabel("x",fontsize=18)
        plt.title('$\\psi$(x, y, '+ str(i) + ')')
        plt.xticks([0, Lx/2, Lx],['0', 'L/2', 'L'],fontsize=16)
        plt.yticks([0, Ly/2, Ly],['0', 'L/2', 'L'],fontsize=16)
        filename = "SH-2D%04d.png" % (i/plotEveryNth)
        plt.savefig(filename)
        plt.close()