# -*- coding: utf-8 -*-
"""
Created on Wed Jun  4 16:07:05 2014

@author: gurevics
"""

# -*- coding: utf-8 -*-


import numpy as np
import matplotlib.pyplot as plt


Lx = 64 #Physikalische Länge des Gebietes in x-Richtung
Ly = 64#Physikalische Länge des Gebietes in y-Richtung
Nx = 128# Anzahl Diskretisierungspunkte in x-Richtung
Ny = 128 # Anzahl Diskretisierungspunkte in y-Richtung
# 
x, y = np.meshgrid(np.arange(Nx) * Lx/Nx,np.arange(Ny) * Ly/Ny) #x-Array
kx, ky = np.meshgrid(np.fft.fftfreq(Nx,Lx/(Nx*2.0*np.pi)), np.fft.fftfreq(Ny,Ly/(Ny*2.0*np.pi)))
ksq = kx*kx + ky*ky

psi = 0.0+(np.random.random((Nx,Ny))-0.5)*0.1 #Anfangsbedingung: psi=0+noise*0.1
# Parameter:
eps= 0.1
c=1.0/16.0
b=-0.1 #b=0.0, b=-0.1

t = 0.0
dt = 0.02 #Zeitschritt
T_End = 500
N_t = int(T_End / dt)

plotEveryNth = 200
#
psik = np.fft.fft2(psi) #FFT(psi)
#
def rhs_lin(ksq):
    result=eps-(1.0-ksq)**2
    return result
    
Eu=1.0/(1.0-dt*rhs_lin(ksq))
    
for i in range(N_t):
    psik=Eu*(psik+dt*(np.fft.fft2(-c*np.fft.ifft2(ksq**2*np.fft.fft2(np.fft.ifft2(psik)**2))*np.fft.ifft2(psik)-b*np.fft.ifft2(psik)**3)))    
    psi=np.fft.ifft2(psik)
    if(i % plotEveryNth == 0):
        print("Step %04d" %(i/plotEveryNth))
        plt.subplot(1,2,1)
        plt.cla()
        plt.imshow(psi.real)
        plt.ylabel("y",fontsize=18)
        plt.xlabel("x",fontsize=18)
        plt.title('$\\psi$(x, y, '+ str(i) + ')')
        plt.axis('off')
        plt.subplot(1,2,2)
        plt.cla()
        plt.imshow(np.abs(np.fft.fftshift(psik)))
        plt.title('Fourier space, $|\\widehat{\\psi}_k|$')
        plt.axis('off')
        filename = "SH-2D%04d.png" % (i/plotEveryNth)
        plt.savefig(filename)
        plt.close()