# -*- coding: utf-8 -*-
"""
Created on Wed Jun  4 16:07:05 2014

@author: gurevics
"""

# -*- coding: utf-8 -*-
# Pseudospektralverfahren für Swift-Hohenberg-Gleichung in 2D


import numpy as np
import matplotlib.pyplot as plt


Lx = 64 #Physikalische Länge des Gebietes in x-Richtung
Ly =64#Physikalische Länge des Gebietes in y-Richtung
Nx = 128# Anzahl Diskretisierungspunkte in x-Richtung
Ny = 128 # Anzahl Diskretisierungspunkte in y-Richtung

x, y = np.meshgrid(np.arange(Nx) * Lx/Nx,np.arange(Ny) * Ly/Ny) #x-Array
kx, ky = np.meshgrid(np.fft.fftfreq(Nx,Lx/(Nx*2.0*np.pi)), np.fft.fftfreq(Ny,Ly/(Ny*2.0*np.pi)))
ksq = kx*kx + ky*ky

# Anfangsbedingung:
#c = 0.0+(np.random.random((Nx,Ny))-0.5)*0.1
#c=np.sin(0.88357*x)+(np.random.random((Nx,Ny))-0.5)*0.1 #Zig-Zag instability
c=np.sin(1.178*x)+(np.random.random((Nx,Ny))-0.5)*0.1   # Eckhaus instability (eps=0.3, delta=0), Bistability (eps=0.2,delta=0.5)
# Parameter:
# eps=0.3, delta=0  - Streifen; eps=0.1, delta=1.0- Hexagone (superkritisch), eps=-0.5, delta=4-Hexagone (subkritisch)
eps=0.2
delta=0.5

t = 0.0
dt = 0.01
T_End = 500
N_t = int(T_End / dt)

plotEveryNth = 200
#
ck = np.fft.fft2(c) #FFT(c)

# Lineare Terme
def rhs_lin(ksq):
    result=eps-(1.0-ksq)**2
    return result

# Funktion für den semiimpiziten Schritt    
Eu=1.0/(1.0-dt*rhs_lin(ksq))
    
for i in range(N_t):
    ck=Eu*(ck+dt*(delta*np.fft.fft2(np.fft.ifft2(ck)**2)-np.fft.fft2(np.fft.ifft2(ck)**3)))
    c=np.fft.ifft2(ck)
    if(i % plotEveryNth == 0):
        print("Step %04d" %(i/plotEveryNth))
        plt.suptitle('L='+str(int(Lx))+', N='+str(Nx)+', $\\varepsilon=$'+str(eps)+', $\\delta=$'+str(delta))
        plt.subplot(1,2,1)
        plt.cla()
        plt.imshow(c.real)
        plt.ylabel("y",fontsize=18)
        plt.xlabel("x",fontsize=18)
        plt.title('$\\psi$(x, y, '+ str(i) + ')')
        plt.axis('off')
        #
        plt.subplot(1,2,2)
        plt.cla()
        plt.imshow(np.abs(np.fft.fftshift(ck)))
        plt.title('Fourier space, $|\\widehat{\\psi}_k|$')
        plt.axis('off')
        #
        filename = "SH-2D%04d.png" % (i/plotEveryNth)
        plt.savefig(filename)
        plt.close()