#ifndef GRIDDING_H
#define GRIDDING_H

#ifndef REALTYPE
#define REALTYPE double
#endif

#ifdef __cplusplus
extern "C" {
#endif
  double bessel_i0(double x);
  double kb_weight(double x,double a,double b);
  double kb_coef(double y,double a, double b);

  /* init just weight */
  void init_nefft_kb_weight(int N,int FFT_N,int L,
			    REALTYPE *WeightDiv,
			    REALTYPE alpha);
  /* init intnodes & coef */
  void init_nefft_kb_coef(int N,int FFT_N,int L,
			  int M,REALTYPE *Nodes,
			  int *IntNodes,
			  REALTYPE *Coef,
			  REALTYPE alpha);

  /* init all: calls init_nefft_kb_weight and init_nefft_kb_coef
     to init weight, intnodes & coef */

  void init_nefft_kb(int N,int FFT_N,int L,
		     int M,REALTYPE *Nodes,
		     int *IntNodes,
		     REALTYPE *WeightDiv,
		     REALTYPE *Coef);

  void nedgridding(REALTYPE *rtemp,const REALTYPE *rinput,
		   const int M,const int FFT_N,const int q,
		   const int *IntNodes,const REALTYPE *P);
  
  
  void nedscaling(REALTYPE *routput,const REALTYPE *rtemp,
		  const REALTYPE *weight,
		  const int n,const int FFT_N);
  
  void nergridding(REALTYPE *routput,REALTYPE *rtemp,
		   int M,int FFT_N,int q,
		   const int *IntNodes,const REALTYPE *Q);	     

  void nerscaling(REALTYPE *rtemp,const REALTYPE *rinput,
		  const REALTYPE *weight,
		  int n,int FFT_N);
  
  void nerscaling_real(REALTYPE *rtemp,const REALTYPE *rinput,
		       const REALTYPE *weight,
		       int n,int FFT_N
		       );
  
void ner2gridding(REALTYPE *rResult,const REALTYPE *rTempBase,
		  const int *xIntNodesPtr,const int *yIntNodesPtr,
		  const REALTYPE *xCoef,const REALTYPE *yCoef,
		  int FFT_Nx,int FFT_Ny,int M,int q);

void ned2gridding(REALTYPE *rtemp,const REALTYPE *rinput,
		  const int *xIntNodesPtr,const int *yIntNodesPtr,
		  const REALTYPE *xCoef,const REALTYPE *yCoef,		  
		  int FFT_Nx,int FFT_Ny,int M,int q);

void ner2scalling(REALTYPE *rTemp,REALTYPE *rInput,
		  const REALTYPE *xWeight,const REALTYPE *yWeight,
		  int Nx,int Ny,int FFT_Nx,int FFT_Ny);

void ned2scalling(REALTYPE *rOutput,const REALTYPE *rTemp,
		  const REALTYPE *xWeight,const REALTYPE *yWeight,
		  int Nx,int Ny,int FFT_Nx,int FFT_Ny);

double nefft_calc_approx_err(int N,int FFT_N,int L,
			     REALTYPE x0,REALTYPE *WeightDiv,REALTYPE *coef
			     );

double nefft_approx_err(int N,int FFT_N,int L,
				   int M,REALTYPE *Nodes,
				   int *IntNodes,
				   REALTYPE *WeightDiv,
				   REALTYPE *Coef);


#ifdef __cplusplus
	   }
#endif

#endif
