function [poly,poly_prime] = charPoly(lambda,delta,gamma,n)

% Rekursive Berechnung des char. Polynoms p(lambda) und dessen Ableitung p_prime(lambda)

p(1)=1;                 % p(0)
p(2)=delta(1)-lambda;   % p(1)


p_prime(1)=0;           % p'(0)
p_prime(2)=-1;          % p'(1)


for k = 3:n+1
    p(k) = (delta(k-1)-lambda)*p(k-1)-gamma(k-1)^2*p(k-2);
    p_prime(k)=-p(k-1)+(delta(k-1)-lambda)*p_prime(k-1)-gamma(k-1)^2*p_prime(k-2);
end


poly = p(n+1);
poly_prime = p_prime(n+1);