% Loesung Aufgabe 22: 

close all 
clear all

% Vektor, der die Messpunkte enthaelt: 
t = [1:7].';

% Vektor, der die Messwerte zu den Messpunkten enthaelt: 
b = zeros(7,1);
b(1)=1.2;
b(2)=1.9; 
b(3)=3.1; 
b(4)=4.2; 
b(5)=5.0;
b(6)=6.5;
b(7)=6.8; 

% Systemmatrix
A = [ones(7,1) t];
disp('Die Systemmatrix ist A = ')
disp(A)
disp('Die rechte Seite ist b = ')
disp(b)
% es gibt mehrere Moeglichkeiten zur Loesung von Ax=b.

% 1: Der Matlab Operator \ berechnet die Loesung von Ax=b via x=A\v. Falls
% A ueberbestimmt ist, liefert A\b automatisch die kleinste Quadrate
% Loesung. 

% 2: Bestimme QR-Zerlegung von A via [Q,R]=qr(A) und loese Rx = Q*b 

% 3: Ermittle mit pinv(A) die Pseudoinverse von A und berechne x =
% pinv(A)*b. 

% 4: Loese System ueber die Normalengleichungen, dh loese A.'A x = A.'b

% 1:
x1=A\b;
alpha1=x1(1);
beta1=x1(2);

% 2: 
[Q,R]=qr(A); 
b1 = Q'*b;
x2 = R\b1;
alpha2=x2(1);
beta2=x2(2); 

% 3: 
x3 = pinv(A)*b;
alpha3=x3(1);
beta3=x3(2);

% 4: 
x4 = A.'*A\A.'*b;
alpha3=x4(1);
beta3=x4(2);

disp('                                    ')
disp('Das System reduziert sich zu dem LGS')
disp('                                    ')
disp('           Rx=(Q^*)*b               ')
disp('                                    ')
disp('mit R =                             ')
disp(R)
disp('                                    ')
disp('und (Q^*)*b =                       ')
disp(b1)
disp('                                    ')

disp(['Die Ausgleichsgerade ist y(t) = ',num2str(alpha2),' +',num2str(beta2),'*t'])
t_plot=[0:8]';
y = alpha2*ones(9,1)+beta2*t_plot;


figure(1)
plot(t_plot,y,'k')
hold on
plot(t(1),b(1),'x')
plot(t(2),b(2),'x')
plot(t(3),b(3),'x')
plot(t(4),b(4),'x')
plot(t(5),b(5),'x')
plot(t(6),b(6),'x')
plot(t(7),b(7),'x')
hold off
axis([0,8,0,9])
title('Ausgleichsgerade y(t) fuer die Werte aus Aufgabe 22')
xlabel('t')
ylabel('y')
legend('Ausgleichsgerade','Messpunkte',4)