function [A,b,index] = gaussElim(A,b,N,index,pivot)

% Gauss Elimination:
 for j=1:N-1
    if pivot==1
        for k = j+1:N
            % Pivotsuche:
            if abs(A(k,j)) > abs(A(j,j))
                U = A(j,:);         % Zeilentausch in der Matrix
                A(j,:) = A(k,:);
                A(k,:) = U;  
                u=b(j);             % Zeilentausch im Vektor b
                b(j)=b(k);
                b(k)=u;
                piv=index(j);       % Zeilentausch im Vektor index
                index(j)=index(k);
                index(k)=piv;
            end
        end 
    end% if pivot==1
     for i=j+1:N
        A(i,j) = A(i,j)/A(j,j);
        for k=j+1:N
            A(i,k)=A(i,k)-A(i,j)*A(j,k);
        end
        % A(i,:) = A(i,:) - A(j,:)*l;
        b(i) = b(i) - A(i,j)*b(j);
     end
 end

% Rueckwaertseinsetzen
x = zeros(N,1);

x(N) = b(N) / A(N,N);

for i=N-1:-1:1
	summe = 0;
	for j=i+1:N
		summe = summe + A(i,j) * x(j);
	end;
	x(i) = (b(i)- summe) / A(i,i);
end

b = x; 
clear x

disp(' ')
disp('Die LR-Zerlegung von A ist')
disp(A)
disp(' ')
disp('Die Loesung des LGS Ax=b ist')
disp(b)
disp(' ')
disp('Es wurden folgende Permutationen durchgefuehrt: ')
disp(index)
disp(' ')