%% This code must be compiled using the "mex" command once before this demo will work:
str = computer('arch');
system(['mex -' str ' SplitBregmanROF.c']); % SplitBregmanROF.c (MEX version) by Tom Goldstein

%% Step 1:  Get the test image
filename = 'cameraman'; ext = '.tif';
%filename = '/u/c_brun02/vorlesung_variationsmethoden/testbilder_denoising/100_0502'; ext = '.JPG';

% read data
exact = imread([filename ext]);
if size(size(exact),2) == 3
    exact = rgb2gray(exact);
end
exact = double(exact);
[nx ny] = size(exact);

% add noise
noise_strength = 20;
f = exact+noise_strength*randn(nx,ny);

%% Step 2: Denoise the Image
tic;
lambda = .05; tol = 1e-3; maxIts = 100;
[u alg_error its] = SplitBregmanROF(f,lambda,tol,maxIts);
toc;
alg_error
its

%% Step 3:  Display Results
figure;
subplot(2,2,1); imagesc(exact); colormap(gray); colorbar; title('Original'); 
subplot(2,2,2); imagesc(f); colormap(gray); colorbar; title('f');
subplot(2,2,3); imagesc(u); colormap(gray); colorbar; title('denoised');
subplot(2,2,4); imagesc(f-u); colormap(gray); colorbar; title('difference');