function [ x ] = myQRsolve( QR,alpha,b )

%Allocate Matrices
Q = eye(size(QR,1));
R = zeros(size(QR));

for i=1:size(QR,2)
    %Extract R
    R(i,i) = alpha(i);
    R(1:i-1,i) = QR(1:i-1,i);
    
    %Rebuild Q
    v = QR(i:end,i);
    tmpQ = eye(size(QR,1));
    tmpQ(i:end,i:end) = tmpQ(i:end,i:end) - 2/(v'*v)*(v*v');
    
    Q = Q * tmpQ';
end

%Solve Equation
z = Q'*b;
x = R\z;

end

