function [A, alphavec] = myQR( A )
%HOUSEHOLDER compute QR decomposition of A by householder
%operations. R always has A size (different from script).
[m n]=size(A);
mi=min(n,m);
alphavec=zeros(mi,1);
for i=1:mi
    alpha=sign(A(i,i))*norm(A(i:end,i));
    
    if (alpha == 0)
        alpha = 1;
    end
    
    v=A(i:end,i);
    v(1)=v(1)+alpha;

    A(i:end,i:end)=A(i:end,i:end)-2/(v'*v)*v*(v'*A(i:end,i:end));
    
    alphavec(i)=A(i,i);
    
    A(i:end,i)=v;
end
end

