function B=solvecholesky( L,B )
%SOLVECHOLESKY Solve linear equation using Cholesky 
%decomposition.
[n n]=size(L);
%Forward
for i=1:n
    for j=1:i-1
        B(i,:)=B(i,:)-L(i,j)*B(j,:);
    end
    B(i,:)=B(i,:)/L(i,i);
end
%Backward
for i=n:-1:1
    for j=i+1:n
        B(i,:)=B(i,:)-L(j,i)*B(j,:);
    end
    B(i,:)=B(i,:)/L(i,i);
end
end

