function [L,ROP] = cholesky( A )
%CHOLESKY Compute Cholesky decomposition of A.
%A is assumed to be symmetric, only the lower left is used.
%We make sure that the function can be used on symbolic input.
L=zeros(size(A));
if (~isnumeric(A))
    L=sym(L);
end
[n n]=size(A);

ROP = 0;

for k=1:n
    L(k,k)=A(k,k);
    ROP = ROP + 1;
    if (k>1)
        L(k,k)=L(k,k)-dot(L(k,1:k-1),L(k,1:k-1));
        ROP = ROP + k;
    end
    if (isnumeric(A))
    if (L(k,k)<=0)
        'Matrix is not s.p.d.'
    end
    end
    L(k,k)=sqrt(L(k,k));
    ROP = ROP + 1;
    if (k<n)
    L(k+1:n,k)=A(k+1:n,k);
    ROP = ROP + (n-k+1);
    for i=1:k-1
        L(k+1:n,k)=L(k+1:n,k)-L(k,i)*L(k+1:n,i);
        ROP = ROP + (n-k+1);
    end
    L(k+1:n,k)=L(k+1:n,k)/L(k,k);
    end
    if (~isnumeric(A))
    L=simplify(L);
    end
end
end

