clear all;close all;clc;

image = im2double(imread('cameraman.tif'));
%image = imresize(image,0.25);
image = double(image);
filt=fspecial('gaussian',15,3);
figure; imagesc(image);
title('Original image');

imageneu1=real(fft_convolve(image,filt,3));
figure; imagesc(imageneu1);
title('Convolved image (symmetric)');

imageneu2=real(fft_convolve_no_overlap(image,filt,3));
figure; imagesc(imageneu2);
title('Convolved image (non-symmetric)');

imageneu3=real(fft_convolve(imageneu1,filt,3,1));
figure; imagesc(imageneu3);
title('Reconstructed image (no noise)');

imageneu4=real(fft_convolve(imageneu2,filt,3,1));
figure; imagesc(imageneu4);
title('Reconstructed image (no noise, no overlap)');

noise=randn(size(imageneu1));
l2=norm(noise(:));
epsilon=1e-2;
noise=noise/l2*epsilon;
perpixel=epsilon/numel(noise);
imageneu5=real(fft_convolve(imageneu1+noise,filt,3,1));
figure; imagesc(imageneu5);
title(['Reconstructed image (with noise ' num2str(perpixel) ' per-pixel)']);


return;
