function yhat = myifft( y ,choice)
%MYFFT
%This is not really fast - it shows how the FFT
%computes its way. Do not use for real computations!
%This is he Cooley-Tukey algorithm.
format compact;
if (nargin<1)
    y=ones(1025,1);
end
if (nargin<2)
    choice=1;
end
%if (size(y,1)>1)&&(size(y,2)>1)
for i=1:size(y,1)
    y(i,:)=dofft(y(i,:),choice);
end
yhat=y;
for i=1:size(y,2)
    y(:,i)=dofft(y(:,i),choice);
end
yhat=y;
return
%end

end

function yhat=dofft(y,choice)
if (choice==0)
    yhat=simpleft(y);
else
    if (choice==1)
        yhat=fastft(y);
    else
        yhat=fft(y)/sqrt(numel(y));
    end
end
end

function yhat = simpleft(y)
n=numel(y);
yhat=zeros(n,1);
omega=exp(-i*2*pi/n);
for j=0:n-1
    sum=0;
    for k=0:n-1
        sum=sum+omega^(k*j)*y(k+1);
    end
    yhat(j+1)=1/sqrt(n)*sum;
end
end

function yhat = fastft(y)
n=numel(y);
f=factor(n);
yhat=zeros(n,1);
if (n<33)
    yhat=simpleft(y);
    return;
end
if (numel(f)==1)
    %prime number - should use prime FFT algorithm
    yhat=simpleft(y);
else
    p=f(2);
    q=n/p;
    omega=exp(-2*pi*i/n);
    A=zeros(q,p);
    B=A;
    for r=0:p-1
        v=zeros(q,1);
        for s=0:q-1
            v(s+1)=y(q*r+s+1);
        end
        v=fastft(v);
        for k2=0:q-1
            A(k2+1,r+1)=v(k2+1);
        end
    end
    for r=0:p-1
        for k2=0:q-1
            B(k2+1,r+1)=omega^(k2*r)*A(k2+1,r+1);
        end
    end
    for k2=0:q-1
        v=zeros(p,1);
        for r=0:p-1
            v(r+1)=B(k2+1,r+1);
        end
        v=fastft(v);
        for k1=0:p-1
            yhat(k1*q+k2+1)=1/sqrt(n)*v(k1+1);
        end
    end
end
end

