function convolve = fft_convolve( img, filt, choice, backwards )
%FFT_CONVOLVE Convolve image and filter function
[n1 n2]=size(img);
[n3 n4]=size(filt);
if (nargin<3)
    choice=1;
end
if (nargin<4)
    backwards=0;
end    
N=max(n1,n3);
M=max(n2,n4);
newimg=zeros(N,M);
newimg(1:n1,1:n2)=img;
newfilt=zeros(N,M);
newfilt(1:n3,1:n4)=filt;
imgF=myfft(newimg,choice);
filtF=myfft(newfilt,choice);
if (backwards==1)
    I=find(abs(filtF)>1e-7);
    convolveF=imgF;
    convolveF(I)=imgF(I)./filtF(I);
else
    convolveF=imgF.*filtF;
end
convolve=myifft(convolveF,choice);
convolve=convolve*prod(sqrt(size(convolve)));


