%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Dieses Programm erzeugt einen Film
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all
clear all

N = 20; % Anzahl der Bilder im Film
M = moviein(N); % Initialisieren des Films

[X,Y] = meshgrid(-pi:.1:pi); % Gitter erzeugen

for t = 1:N
    
    f = cos(X-(t* pi)/N).*sin(Y-(t*pi)/N); % aktualisieren der Funktion f 
                                                 % in jedem Schritt
    meshc(X,Y,f); % Plotten, in jedem Schritt
    
    M(:,t) = getframe
    
end

movie(M,2); % Wiederholden des Films
