    % Beispiel fuer einen 3D plot:

    clear all
    close all
    
    
    % 1) mit Meshgrid:


    L = 8;                      % will auf Gebiet [0,L]x[0,L] plotten 
    N = 40;                     % Anzahl der Gitterpunkte
    h = L/(N-1);                % Schrittweite
    [x,y] = meshgrid(0:h:L);    % Erzeuge Gitter in xy-Ebene
    f = cos(x).*sin(y);     
    figure(2)
    mesh(x,y,f)
    xlabel('x')
    ylabel('y')
    zlabel('f')
    title('f(x,y)=sin(y)cos(x)')
    axis([0,8,0,8,-1.5,1.5])
    
    
    
    % 2) von Hand erzeugtes Gitter: 

    X = 5;
    Y = 8; 

    nx = 50;
    ny = 80;

    dx = X/(nx-1);
    dy = Y/(ny-1);

    y = [0:dy:Y]';
    x = [0:dx:X]';

    for j=0:1:nx-1
        for k=0:1:ny-1
            f(j+1,k+1) = sin(k*dy)*cos(j*dx);
        end
    end

    figure(1)
    mesh(y,x,f)
    xlabel('y')
    ylabel('x')
    zlabel('f')
    title('f(x,y)=sin(x)cos(y)')
    axis([0,8,0,5,-1.5,1.5])
