% Programm, welches fuer gegebene Werte x und eine gegebene Funktion f 
% einerseits mit Hilfe mit einer Schleife die Ableitungen 
% von f in diesem Punkt x bestimmt und zum Vergleich das Ganze auch
% vektorisiert berechnet

% Clear Workspace

clear all

% Definition von f als anonyme Funktion

f = @(x) sin(x);

% Festlegung der Werte x aus dem Intervall [0,4]

h=0.00002;
x=0:h:4;

% Wir werten f in jedem x aus und speichern diese Werte im Vektor y.

y = f(x);

% Ausserdem berechnen wir die Anzahl der Eintrage. Da die Division einen
% Wert vom Typ double liefert, runden wir mittels dem Befehl round auf die
% naechste natuerliche Zahl, da Indizes immer vom Typ integer sein muessen

n_help = 4/h;
n = round(n_help)

% Belegt man Matrizen mittels einer Schleife, so sollte man vorher die 
% Matrix initialisieren, d.h. entsprechenden Speicher zu allozieren. 
tic;
Dffor = zeros(n,1);

% Berechne die numerische Ableitung mit Hilfe des Differenzenquotienten.

for i = 1:n
    
    Dffor(i) = (y(i + 1) - y(i))/h;
    
end
toc;
t1=toc;

% Plotte zur Kontrolle die Funtkion

%plot(Dffor);

% Da die Verwendung von Schleifen i. Allg. ineffizient ist, vektorisieren
% wir nun obigen Code und messen die Zeit wieder mit tic und toc.
% Wir berechnen die Ableitung indem wir verschiedene Bereiche des Vektors y
% subtrahieren und anschliessend den Vektor Dfvect durch h teilen

tic;

Dfvect = (1/h) .* ( y(2:(n + 1)) - y(1:n) );

toc;
t2=toc;

plot(Dfvect);


