% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
%
% Programm, welches fuer gegebene Werte x und eine gegebene Funktion f 
% einerseits mit Hilfe der Routine/Funktion numAbleitung.m die Ableitungen 
% von f in diesem Punkt x bestimmt und zum Vergleich das Ganze auch noch
% mit einer Schleife berechnet
%
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %

% Definition von f als anonyme Funktion

f = @(x) sin(x);

% Festlegung der Werte x aus dem Intervall [0,4]

h=0.02;
x=0:h:4;

% Berechne die Ableitung von f auf dem Intervall [0,4]
% D.h. Dy ist ein Vektor der gleichen Laenge wie x. Die Zeit messen wir mit
% den Befehlen tic und toc.

tic;

Dy = numAbleitung(f,x,h);

toc;
t1 = toc;

% Zur Kontrolle plotten wir die Ableitung

%plot(Dy);

% Bei der Berechnung von Dy wird fuer jeden Eintrag die Funktion
% numAbleitung(f,x,h) aufgerufen. Dies ist ineffizient. In der Funktion 
% numAbleitung(f,x,h) wird dann f einmal in x und einmal in x + h 
% ausgewertet, also fuer jedes x zweimal. Wesentlich effizienter ist es f
% einmal in jedem x auszuwerten, das in einem Vektor y zu speichern und
% dann mittels einer Schleife die numerische Ableitung zu bestimmen.

% Wir werten f in jedem x aus und speichern diese Werte im Vektor y.
% Ausserdem berechnen wir die Anzahl der Eintrage. Da die Division einen
% Wert vom Typ double liefert, runden wir mittels dem Befehl round auf die
% naechste natuerliche Zahl, da Indizes immer vom Typ integer sein muessen

tstart = tic;
y = f(x);
n_help = 4/h;
n = round(n_help);

% Belegt man Matrizen mittels einer Schleife, so sollte man vorher die 
% Matrix initialisieren, d.h. entsprechenden Speicher zu allozieren. 

Dffor = zeros(n,1);

% Berechne die numerische Ableitung mit Hilfe des Differenzenquotienten.

for i = 1:n
 
    Dffor(i) = (y(i + 1) - y(i))/h;
    
end

toc(tstart);
t2=toc(tstart);

plot(Dffor);