% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
% 
%  Loesung zu Aufgabe 2. Dieses Programm berechnet mit Hilfe des
%  Intervallschachtelungsverfahren zu einer gegebenen stetigen Funktion f
%  eine Nullstelle. 
%
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %

% Waehle das lange Ausgabenformat

format long;


% Definiere die vorgegebene Toleranz

tol = 1.0e-8;


% Definition unserer stetigen Funktion mit Nullstelle

f = @(x) x^3;

% Definition der Intervallgrenzen

a = -2;
b = 1;

% Test ob Intervallgrenzen zulaessig gewaehlt

if a > b
    
    error('Die linke Intervallgrenze ist groesser als die rechte. Bitte tauschen Sie die Intervallgrenzen')


elseif (f(a) * f(b) > 0)
    
    error('Es existiert keine Nullstelle innerhalb des gewaehlten Intervalls. Bitte vergroessern Sie das Intervall.')

        
end

% Definiere Mitte des aktuellen Intervalls

x = (1/2) *(a + b);

% Berechne mit Hilfe der Toleranz und der Fehlerabschaetzung wie viele
% Iterationen wir durchfuehren muessen.

Iteration = - log2((tol/(b - a))) - 1;

N = ceil(Iteration); % ceil rundet zur naechst groesseren natuerlichen Zahl

% Berechne nun rekursiv die Nullstelle

for n = 1:N
    
    if (f(a) * f(b)) == 0
    
        if f(a) == 0
        
            nullstelle = a
        
        elseif f(b) == 0
        
            nullstelle = b
        
        end
        
        % Wir beenden den Algorithmus durch die Verwendung von break
        
        break;
        
    elseif (f(a) * f(x)) < 0
        
        % Wir wechseln ins linke Intervall
        
        b = x
        
    elseif (f(a) * f(x)) > 0
        
        % Wir wechseln ins rechte Intervall
        
        a = x
        
    end
    
    % Berechne vom neuen Intervall die Mitte
    
    x = (1/2) *(a + b);

end

% Findet der Algorithmus keine exakte Nullstelle, erreicht aber die
% geforderte Toleranz durch das Abarbeiten aller Iterationen, so waehlen
% wir die Nullstelle wie folgt:

nullstelle = x
    