function p = charpol(A)
% Dieses Programm berechnet das charakteristische Polynom zu einer
% gegebenen Matrix A

% Die Determinante von (A - t*eye(3)) laesst sich mit der Regel von Sarrus
% wie folgt berechnen:
% determinante = @(t) (A(1,1) -t)*(A(2,2) - t)*(A(3,3) - t) + A(1,2)*A(2,3)*A(3,1) + A(1,3)*A(2,1)*A(3,2) ...
%                     - A(3,1)*(A(2,2) - t)*A(1,3) - A(3,2)*A(2,3)*(A(1,1) - t) - (A(3,3) - t)*A(2,1)*A(1,2);
      
% Wir definieren von Hand die Koeffizienten des charakteristischen Polynoms

% Koeffizient vor t^3

p3 = -1;

% Koeffizient vor t^2

p2= A(1,1) + A(2,2) + A(3,3);

% Koeffizient vor t^1

p1= A(1,3)*A(3,1) + A(2,3)*A(3,2) + A(1,2)*A(2,1) - A(1,1)*A(3,3) - A(2,2)*A(3,3) - A(1,1)*A(2,2);

% Koeffizient vor t^0

p0= A(1,2)*A(2,3)*A(3,1) + A(1,3)*A(3,2)*A(2,1) + A(1,1)*A(2,2)*A(3,3) ...
      - A(1,1)*A(2,3)*A(3,2) - A(2,2)*A(1,3)*A(3,1) - A(3,3)*A(1,2)*A(2,1);
  
% Definition des charakteristischen Polynoms

p = [p3 p2 p1 p0];