%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% >>>> IMAGEBOX >>>> JX >>>> UCLA >>>>
%%
%% image toolbox
%% MATLAB file
%% 
%% normalize.m
%% normalize a matrix/vector to fixed mean
%%
%% function v = normalize(u, newmean)
%% input:  u: matrix or vector
%%         newmean: new mean value. default = 0
%% output: v: normalized matrix/vector
%%         
%% created:       03/10/2005
%% last modified: 03/16/2005
%% author:        jjxu@ucla
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function v = normalize(u, newmean)

if exist('newmean') ~= 1, newmean = 0; end;

shift = -mean(mean(u)) + newmean;

if shift ~= 0, v = u + shift; else v = u; end;

return
