function varargout = radartool(varargin)
% RADARTOOL M-file for radartool.fig
%      RADARTOOL, by itself, creates a new RADARTOOL or raises the existing
%      singleton*.
%
%      H = RADARTOOL returns the handle to a new RADARTOOL or the handle to
%      the existing singleton*.
%
%      RADARTOOL('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in RADARTOOL.M with the given input arguments.
%
%      RADARTOOL('Property','Value',...) creates a new RADARTOOL or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before radartool_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to radartool_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help radartool

% Last Modified by GUIDE v2.5 22-May-2006 08:00:40

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @radartool_OpeningFcn, ...
                   'gui_OutputFcn',  @radartool_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before radartool is made visible.
function radartool_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to radartool (see VARARGIN)

% Choose default command line output for radartool
handles.output = hObject;
global z1;
z1=0;
drawit(handles);
% Update handles structure
guidata(hObject, handles);

% UIWAIT makes radartool wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = radartool_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

% --- Executes on slider movement.
function slider4_Callback(hObject, eventdata, handles)
% hObject    handle to slider4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
drawit(handles)

% --- Executes during object creation, after setting all properties.
function slider4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end

% --- Executes on slider movement.
function slider6_Callback(hObject, eventdata, handles)
% hObject    handle to slider6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
drawit(handles)

% --- Executes during object creation, after setting all properties.
function slider6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function slider7_Callback(hObject, eventdata, handles)
% hObject    handle to slider7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

drawit(handles)

% --- Executes during object creation, after setting all properties.
function slider7_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end

function drawit(handles)
global z1 koordsx koordsy koordsr koordsphi N R;
omega0=get(handles.slider6,'Value');
omega1=get(handles.slider7,'Value');
psi=get(handles.slider4,'Value');
N=get(handles.slider8,'Value');
N=round(N);
if (N<2)
    N=2;
end

R=2;
if (numel(z1)<100)    
%    name=['image.' num2str(N) '.mat'];
%    fid=fopen(name,'r');
%    if (fid==-1)
%        slowsave(N,R,name);
%    else
%        fclose(fid);
%    end
%    load(name);
    koordsx=[0:N-1 -N:-1]'*ones(1,2*N)*pi/R;
    koordsy=koordsx';
    koordsr=hypot(koordsy,koordsx);
    koordsphi=abs(atan2(koordsx,koordsy));
    z1=fourval(koordsx,koordsy)*N^2/R^2*(2*pi);
    tmpx=[0:N-1 -N:-1]'*ones(1,2*N);
    tmpx=tmpx+tmpx';
    z1=z1.*(1-2*mod(tmpx,2));
end
z=z1;
z(koordsphi>psi)=0;
z(koordsr<omega0)=0;
z(koordsr>omega1)=0;
axes(handles.axes1);
imagesc([-N*pi/R N*pi/R],[-N*pi/R N*pi/R],fftshift(log(abs(z)+1e-5)));
axes(handles.axes2);
im=ifft2(z);
imagesc([-R R],[-R R],abs(im));
axis equal;
colorbar;
set(handles.text13,'String',['Radar simulation: psi=' num2str(psi) ' omega0=' num2str(omega0) ' omega1=' num2str(omega1) ' N=' num2str(N)]);
function slowsave( N,R,name )
z1=zeros(2*N,2*N);
for k1=0:2*N-1
    for k2=0:2*N-1
        z1(k1+1,k2+1)=ftval(k1,k2,R,N);
    end
end
save(name,'z1');

%Berechne den k. Koeffizienten der diskreten Fouriertrafo der
%Lnge N, wenn die Funktion auf [-R,R] vertafelt wird.
function y=ftval(k1,k2,R,N)
if (k1>N-1)
    k1=k1-2*N;
end
if (k2>N-1)
    k2=k2-2*N;
end
y=fourval(pi*k1/R,pi*k2/R)*(1-2*mod(k1+k2,2))*N^2/R^2*(2*pi);

%Analytische Fouriertransformation
function y=fourval(xi1,xi2)
phi=30/180*pi;
y1= cos(phi)*xi1+sin(phi)*xi2;
y2=-sin(phi)*xi1+cos(phi)*xi2;
y=2/pi*sinc(y1).*sinc(y2);


% --- Executes on slider movement.
function slider8_Callback(hObject, eventdata, handles)
% hObject    handle to slider8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
global z1;
z1=0;
drawit(handles);

% --- Executes during object creation, after setting all properties.
function slider8_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


