// simple Sobel Filter example
// Author: Michel Steuwer (michel.steuwer@wwu.de)
// The hole code is based on the Sobel Filter example of the NVIDIA CUDA SDK

#ifndef __SOBELFILTER_KERNELS_H_
#define __SOBELFILTER_KERNELS_H_

typedef unsigned char Pixel;

// global determines which filter to invoke
enum SobelDisplayMode {
	SOBELDISPLAY_IMAGE = 0,
	SOBELDISPLAY_SOBEL,
	SOBELDISPLAY_SOBEL_FULL
};

// text to show in the title
static char *filterMode[] = {
	"Original",
	"Sobel Filter",
	"Sobel Filter full image",
	NULL
};

extern enum SobelDisplayMode g_SobelDisplayMode;

extern "C" void sobelFilter(unsigned char *odata, int iw, int ih, enum SobelDisplayMode mode, float fScale, int sobelWidth);
extern "C" void setupTexture(int iw, int ih, unsigned char *data, int Bpp);
extern "C" void deleteTexture(void);
extern "C" void initFilter(void);

#endif
