#ifndef NBODY_STOPWATCH_HH
#define NBODY_STOPWATCH_HH

#include <ctime>
#include <chrono>

/**
 * A class for time measurements .
 */
class Stopwatch
{
public:
  Stopwatch ()
    : running(false)
  {}

  // start time measurement
  void start ()
  {
    running = true;
    start_wall = Clock::now();
  }

  // stop time measurement
  void stop ()
  {
    running = false;
    stop_wall = Clock::now();
  }

  // measured total time; also callable during time measurement
  double elapsed ()
  {
    if (running)
    {
      tmp_wall = Clock::now();
      return measure(start_wall,tmp_wall);
    }
    return measure(start_wall,stop_wall);
  }

private:
  using Clock = std::chrono::high_resolution_clock;
  using TimePoint = std::chrono::time_point<Clock>;
  
  double measure (TimePoint& start, TimePoint& stop)
  {
    return std::chrono::duration<double>(stop-start).count();
  }
  
  TimePoint start_wall;
  TimePoint stop_wall;
  TimePoint tmp_wall;
  bool running;
};


#endif // NBODY_STOPWATCH_HH
