#include <iostream>
#include <mpi.h>

int main(int argc, char *argv[]) {
  MPI_Init(&argc, &argv);  // initialisiere MPI. Dies MUSS in jedem MPI Programm ausgeführt werden.
                           // Erst danach dürfen anderen MPI Befehlen stehen.

  int rank;
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);  // Bestimme den Rang des Prozesses (Prozessnummer).
                                         // Der Rang ist eine Zahl zwischen 0,...,p,
                                         // wobei p die Anzahl an verfügbaren Prozessen ist.
                                         // MPI_COMM_WORLD ist eine von MPI vordefinierte Gruppe von Prozessen,
                                         // die alle teilnehmenden Prozesse enthält.
  std::cout << "Hello, World from " << rank << std::endl;

  MPI_Finalize();  // Beende MPI. Dies MUSS in jedem MPI Programm ausgeführt werden.
                   // Danach darf kein MPI Befehl ausgeführt werden.
}