#include <map>
#include <string>
#include <cstdlib>
#include <iostream>
#include <exception>

#include "include/utilities/nbody_exception.hh"
#include "include/nbody.hh"


/**
 * Main program which reads optional options from the command line
 * and then calls the simulation.
 */
int main (int argc, char** argv)
{
  try
  {
    // a map for collecting the options
    std::map<std::string,std::string> options;

    // set default parameters
    options["N"] = "2000";          // number of bodies
    options["T"] = "100.0";         // maximum time
    options["dt"] = "1e-4";         // time step size
    options["o"] = "1e-1";          // time step size for data output
    options["init"] = "threebody";  // name of initial configuration

    // parse command line parameters
    for (int i = 1; i < argc; i++)
    {
      std::string key = argv[i];
      const std::string::size_type sub = key.find("=");
      if (sub == std::string::npos)
        throw NBody_Exception("Failed to parse option " + key);
      std::string val = key.substr(sub+1);
      key.erase(sub);
      options[key] = val;
    }

    // read final parameters
    const unsigned int N = atoi(options["N"].c_str());
    const double T = atof(options["T"].c_str());
    const double dt = atof(options["dt"].c_str());
    const double o = atof(options["o"].c_str());
    const std::string init = options["init"];

    // create n-body simulation object
    //NBody nbody(N,T,dt,o,init);

    // execute simulation
    //nbody.simulate();
  }
  catch (std::exception& e)
  {
    std::cout << "ERROR: " << e.what() << std::endl;
  }
}
