#ifndef TIMEFUNCTION_HH
#define TIMEFUNCTION_HH

/**
 * Interface for representing time-dependent functions
 * f: R \times R^n --> R^m, (t,x) |--> f(t,x).
 * @tparam Domain The type representing the function's spatial domain R^n.
 * @tparam Range  The type representing the function's range R^m.
 * @tparam Time   The type representing the function's temporal domain R.
 */
template <typename Domain, typename Range, typename Time = double>
class TimeFunction
{
public:
  typedef Domain DomainType;
  typedef Range RangeType;
  typedef Time TimeType;

  /**
   * Pure virtual function (abstract method) that maps t in TimeType
   * and x in DomainType to y in RangeType.
   * @param[in]  t Point in temporal domain.
   * @param[in]  x Point in spacial domain.
   * @param[out] f The function value f(t,x).
   */
  virtual void evaluate (const TimeType& t,
                         const DomainType& x, RangeType& f) const = 0;
};

#endif // TIMEFUNCTION_HH
