#ifndef NBODY_PHYSICS_HH
#define NBODY_PHYSICS_HH

// physical parameters
constexpr double mass_sun = 1.988435e30;
constexpr double pc_in_m = 3.08567758129e16;
constexpr double gamma_si = 6.67428e-11;

// set gravity constant
constexpr double G = gamma_si/(pc_in_m*pc_in_m*pc_in_m)*mass_sun*(365.25*86400)*(365.25*86400);

// math constants
constexpr double Pi = 3.141592653589793238462643383279;

#endif // NBODY_PHYSICS_HH
