#ifndef NBODY_DATAWRAPPER_HH
#define NBODY_DATAWRAPPER_HH

#include "nbody_datastructure.hh"
#include "nbody_exception.hh"


/**
 * Class template that provides unified access to the data
 * for both data structures DataVariant1 and DataVariant2.
 * (Should not be used by you as a student. Intended only
 *  for internal use by NBody_InitialSetup and NBody_VTKWriter)
 * @tparam DataVariant Type representing the data set which
 *                     contains the position, velocity and mass
 *                     of the bodies.
 */
template <typename DataVariant>
class NBody_DataWrapper{};

template <>
class NBody_DataWrapper<DataVariant1>{
public:
  /**
   * Creates an instance of a DataWrapper.
   * @param[in,out] data Data set which contains the position,
   *                     velocity and mass of the bodies.
   */
  NBody_DataWrapper (DataVariant1& data)
      : data_(data)
  {}

  /**
   * Access to position of the i-th body.
   */
  auto& r (const unsigned int i)
  {
    return data_[i].r_i;
  }
  auto r (const unsigned int i) const
  {
    return data_[i].r_i;
  }

  /**
   * Access to velocity of the i-th body.
   */
  auto& v (const unsigned int i)
  {
    return data_[i].v_i;
  }
  auto v (const unsigned int i) const
  {
    return data_[i].v_i;
  }

  /**
   * Access to mass of the i-th body.
   */
  auto& m (const unsigned int i)
  {
    return data_[i].m_i;
  }
  auto m (const unsigned int i) const
  {
    return data_[i].m_i;
  }

  /**
   * Get number of bodies.
   */
  auto size () const
  {
    return data_.size();
  }

  /**
   * Resize data structure with a new number of bodies.
   * This method should only be needed by special initial
   * configurations with a fixed number of bodies (like
   * "threebody")
   */
  void resize (const unsigned int size)
  {
    data_.resize(size);
  }

private:
  // store data reference
  DataVariant1& data_;
};


#endif // NBODY_DATAWRAPPER_HH
