#ifndef NBODY_DATASTRUCTURE_HH
#define NBODY_DATASTRUCTURE_HH

#include <cassert>
#include <array>
#include <vector>

// type for representing vectors in R^3
using Vector3D = std::array<double,3>;
#include "nbody_vectoroperations.hh"

// variant 1
struct Body
{
  Vector3D r_i;
  Vector3D v_i;
  double m_i;
 
  // compare two bodies
  bool operator==(const Body& b) const
  {
    return (r_i == b.r_i && v_i == b.v_i && std::fabs(m_i-b.m_i)<1e-16);
  }
};


// new DataStructure Quadrant should look like this
// please fill in the functions
struct Quadrant
{
  // construct from lowerLeft and upperRight coordinates
  Quadrant(const Vector3D ll, const Vector3D ur) = delete;

  // default construct unit-square
  Quadrant() = delete;

  // check if this Quadrant contains a point
  bool contains(const Vector3D& point) = delete;

  // calculate length of Quadrant
  double length() const = delete;

  // create quadrants produced by dividing this Quadrant into quarters
  // north east corner
  Quadrant NO() = delete;
  // south east corner
  Quadrant SO() = delete;
  // south west corner
  Quadrant SW() = delete;
  // north west corner
  Quadrant NW() = delete;

private:
  Vector3D lowerLeft;
  Vector3D upperRight;
};


// Node of a Quad Tree Structure
struct QuadTreeNode
{
  explicit QuadTreeNode(Quadrant q) : body(), quad(q) {}
  QuadTreeNode() : body(), quad() {}

  bool isLeaf = true;
  bool isEmpty = true;
  Body body;
  Quadrant quad;

  std::vector<QuadTreeNode> children;
};


using DataVariant1 = std::vector<Body>;

#endif // NBODY_DATASTRUCTURE_HH
