#!/bin/bash

# remove old data
rm data.txt

# compile and execute with different N
make nbody
for N in $(seq 100 100 10000)
do
    # execute
    T=$(awk "BEGIN {OFMT=\"%.0f\"; print (2e6)/($N*log($N))}")
    timing=$(./nbody init=collision dt=1 o=10000000000 T="$T" N="$N" | grep time)
    echo -e "$N \t $T \t ${timing##*:}"
    echo -e "$N \t $T \t ${timing##*:}" >> data.txt
done
