#include <map>
#include <string>
#include <exception>

#include "include/utilities/nbody_exception.hh"
#include "include/nbody.hh"


/**
 * Main program which reads optional options from the command line
 * and then calls the simulation.
 */
int main (int argc, char** argv)
{
  // a map for collecting the options
  std::map<std::string,std::string> options;

  // set default parameters
  options["N"] = "2000";          // number of bodies
  options["T"] = "100.0";         // maximum time
  options["dt"] = "1e-4";         // time step size
  options["o"] = "1e-1";          // time step size for data output
  options["init"] = "threebody";  // name of initial configuration

  // parse command line parameters
  for (int i = 1; i < argc; i++)
  {
    std::string key = argv[i];
    const std::string::size_type sub = key.find('=');
    if (sub == std::string::npos)
      throw NBody_Exception("Failed to parse option " + key);
    std::string val = key.substr(sub+1);
    key.erase(sub);
    options[key] = val;
  }

  // read final parameters
  const std::size_t N = std::stoi(options["N"]);
  const double T = std::stod(options["T"]);
  const double dt = std::stod(options["dt"]);
  const double o = std::stod(options["o"]);
  const std::string init = options["init"];

  // create n-body simulation object
  NBody nbody(N,T,dt,o,init);

  // execute simulation
  nbody.simulate();
}
