#ifndef NBODY_EXCEPTION_HH
#define NBODY_EXCEPTION_HH

#include <exception>
#include <string>


/**
 * An exception class for exceptions which are
 * related to our n-body problem code.
 */
class NBody_Exception
  : public std::exception
{
public:
  explicit NBody_Exception (std::string msg) noexcept
    : msg_(std::move(msg))
  {}

  ~NBody_Exception() noexcept override = default;

  const char* what () const noexcept override
  {
    return msg_.c_str();
  }

private:
  std::string msg_;
};


#endif // NBODY_EXCEPTION_HH
