#ifndef NBODY_DATASTRUCTURE_HH
#define NBODY_DATASTRUCTURE_HH

#include <array>
#include <vector>

// type for representing vectors in R^3
using Vector3D = std::array<double,3>;
#include "nbody_vectoroperations.hh"

// variant 1
struct Body
{
  Vector3D r_i;
  Vector3D v_i;
  double m_i;
};

// variant 2
struct Data
{
  std::vector<Vector3D> r;
  std::vector<Vector3D> v;
  std::vector<double> m;
};

// typedefs for both considered data structures
using DataVariant1 = std::vector<Body>;
using DataVariant2 = Data;

#endif // NBODY_DATASTRUCTURE_HH
