#ifndef NBODY_ACCELERATION_HH
#define NBODY_ACCELERATION_HH

#include <vector>
#include <cassert>
#include <cmath>

#include "utilities/timefunction.hh"
#include "utilities/nbody_datastructure.hh"
#include "utilities/nbody_vectoroperations.hh"
#include "utilities/nbody_physics.hh"


/**
 * Right hand side function f of the n-body initial value problem of second
 * order
 *   r'' = f(r) on [t_0,T], r(t_0) = r_0, r'(t_0) = v_0,
 * with f: (R^3)^n --> (R^3)^n, t_0,T \in R_0^+, r_0,v_0 \in (R^3)^n, n \in N.
 * This function computes a vector a := f(r) containing the acceleration of
 * the bodies.
 */
class NBody_Acceleration : public TimeFunction</* depends on data layout */, double>{
public:
  /**
   * Creates an instance of the right hand side function.
   * @param[in] m Vector containing the mass of the bodies.
   */
  NBody_Acceleration (/* depends on data layout */)
    : m_(m)
  {}


  /**
   * Compute acceleration vector with n^2 algorithm.
   * @param[in]  t Point in temporal domain;
   *               not used here as we solve an autonomous problem.
   * @param[in]  r Vector containing the position of the bodies.
   * @param[out] a Vector containing the acceleration of the bodies.
   */
  virtual void evaluate (const typename NBody_Acceleration::TimeType& /*t*/,
                         const typename NBody_Acceleration::DomainType& r,
                         typename NBody_Acceleration::RangeType& a) const
  {
    // your code here
  }

private:
  const std::vector<double>& m_;
};


#endif // NBODY_ACCELERATION_HH
