import numpy as np


def pivoting(A, j):
    return np.argmax(np.abs(A[j:, j])) + j


def zeilen_tauschen(A, i, j):
    if i == j:
        return

    x = A[i, :].copy()
    A[i, :] = A[j, :]
    A[j, :] = x


def gauss_algorithmus(A, b):
    n = A.shape[0]

    # arbeite mit der erweiterten Matrix C = [A|b]
    C = np.hstack([A, b.reshape((b.shape[0],-1))])

    # Vorwärts-Eliminations (mit Pivoting)
    for i in range(n-1):
        pivotIndex = pivoting(C, i)
        zeilen_tauschen(C, i, pivotIndex)
        assert C[i, i] != 0, 'Die Matrix ist nicht invertierbar'

        for j in range(i+1, n):
            q = C[j, i] / C[i, i]
            C[j, :] = C[j, :] - q * C[i, :]

    # Rückwärts-Elimination (kein Pivoting)
    for i in range(n-1, -1, -1):
        for j in range(i-1, -1, -1):
            q = C[j, i] / C[i, i]
            C[j, :] = C[j, :] - q * C[i, :]

    # Rechte Seite durch Diagonal-Elemente teilen
    x = C[:, -1] / np.diag(C)

    return x


A = np.array([[2., -1, 5, 7],
              [-1, 1, 1, 4],
              [1, 2, -3, -2],
              [3, -1, 1, 0]])
b = np.array([43., 20, -12, 4])

x = gauss_algorithmus(A, b)
residuum = np.linalg.norm(A.dot(x) - b)

print('Lösung:', x)
print('Residuum:', residuum)
