import numpy as np
from numpy.random import uniform

def rayleigh_quotient(A, r):
    return r.dot(A.dot(r)) / r.dot(r)

def find_initial_value(A):
    r = np.zeros(A.shape[0])
    while not A.dot(r).max() > 0:
        r = uniform(size=A.shape[0])
    return r

def power_method(A, n):
    r = find_initial_value(A)
    for i in range(n):
        r = A.dot(r) / np.linalg.norm(A.dot(r))
        print(rayleigh_quotient(A, r))
    return r

def test(A, r, sigma):
    residual = A.dot(r) - r*sigma
    print(np.abs(residual).max())


n = int(input('Iterationen: '))

B = np.eye(3)
B[0][0] = 3.

print(B)
B_r = power_method(B, n)
print(B_r)
test(B, B_r, rayleigh_quotient(B, B_r))
print()


C = np.array([[4., -1., -1], [0.5, 2., -1.], [0., 0., 1.]])

print(C)
C_r = power_method(C, n)
print(C_r)
test(C, C_r, rayleigh_quotient(C, C_r))

