import math

def regula_falsi(f, a, b, tol):
    assert f(a) * f(b) < 0

    c = a - (b - a) / (f(b) - f(a)) * f(a)
    while abs(f(c)) >= tol:
        if f(a) * f(c) > 0:
            a = c
        else:
            b = c
        c = a - (b - a) / (f(b) - f(a)) * f(a)

    return c


print(regula_falsi(lambda x: x**2 - 2, 0, 10, 1e-7))
print(regula_falsi(lambda x: math.sin(x), 0.5, 10, 1e-7))
