import numpy as np

feld = np.zeros((20, 20), dtype=np.int)
glider = np.array([[ 0, 0, 1],
                   [ 1, 0, 1],
                   [ 0, 1, 1]])
feld[3:3+3, 3:3+3] = glider

# feld = np.random.randint(0, 2, (20, 20))


def naechste_generation(feld):

    nachbarn = (feld[0:-2, 0:-2] + feld[0:-2, 1:-1] + feld[0:-2, 2:] +
                feld[1:-1, 0:-2] +                    feld[1:-1, 2:] +
                feld[2:, 0:-2]   + feld[2:, 1:-1]   + feld[2:, 2:]    )

    for i in range(1, feld.shape[0]-1):
        for j in range(1, feld.shape[1]-1):
            if feld[i, j]:
                if nachbarn[i-1, j-1] not in [2, 3]:
                    feld[i, j] = 0
            elif nachbarn[i-1, j-1] == 3:
                feld[i, j] = 1

    return feld


def ausgeben(feld):
    print()
    print(feld)
    print()


def ausgeben_mpl(feld):
    import matplotlib.pyplot as plt
    plt.imshow(feld)
    plt.draw()
    plt.pause(0.01)


for i in range(30):
    ausgeben(feld)
    # ausgeben_mpl(feld)                 # grafische Ausgabe mit Matplotlib
    feld = naechste_generation(feld)
ausgeben(feld)
# ausgeben_mpl(feld)
