import numpy as np


def minor(A, i, j):
    B = np.hstack((A[0:i,  0:j], A[0:i,  j+1:]))
    C = np.hstack((A[i+1:, 0:j], A[i+1:, j+1:]))
    return np.vstack((B, C))


def determinante(A):
    if A.shape[0] == 1:
        return A[0,0]
    else:
        wert = 0.
        for i in range(A.shape[0]):
            wert = wert + (-1)**(i) * A[i, 0] * determinante(minor(A, i, 0))  # eigentlich (-1)**(i+j+2)
        return wert


def sylvester(A):
    n, m = A.shape

    for k in range(1, n+1):
        if determinante(A[0:k, 0:k]) <= 0:
            return False

    return True


A = np.array([[1, -1, 0, 0],
              [-1, 3, -2, 0],
              [0, -2, 5, -3],
              [0, 0, -3, 7]])

B = np.array([[1, 1, 5, 7],
              [1, 2, 6, 8],
              [5, 6, 1, 4],
              [7, 8, 4, 0]])

print('A:', sylvester(A))
print('B:', sylvester(B))
