//
//  PGScheduleView.m
//  EMPlaner
//
//  Created by Patrick Förster on 11.06.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "PGScheduleView.h"
#import "PGUIFactory.h"
#import "PGEntitySetup.h"
#import "PGScheduleSubcell.h"

@implementation PGScheduleView

@synthesize delegate = _delegate;

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code
    }
    return self;
}


-(UIView*) createCellWithFrame: (CGRect) frame 
                                 forRow: (NSUInteger) row 
                               inColumn: (NSUInteger) column 
                       andNumberOfCells: (NSUInteger) size {
    
    UIView* cell = [PGUIFactory createViewFromXib:@"schedule_cells" widthTag:PG_SCHEDULE_CELL andFrame:frame forOwner:self];
    
    CGFloat height = frame.size.height / size;
    CGFloat padding = 5;
    
    Match* match;
    NSDictionary* details;
    for (NSUInteger i = 0; i < size; i++) {
        PGCellIndex* index = [[PGCellIndex alloc] initWithRow:row column:column andIndex:i];
        
        match = [_delegate scheduleView:self matchForIndex:index];
        
        if (match) {
            details = [_delegate scheduleView:self detailsForIndex:index];
            
            CGRect rect = CGRectMake(padding, padding + height * i, frame.size.width-2 * padding, height - 2*padding);
            
            PGScheduleSubcell* subcell = (PGScheduleSubcell*) [PGUIFactory createViewFromXib:@"schedule_cells" 
                                                                                      widthTag:PG_SCHEDULE_SUBCELL 
                                                                                      andFrame:rect 
                                                                                      forOwner:self];
            
            subcell.index = index;
            
            [_delegate setup:subcell withMatch:match andDetails:details];
            
            [cell addSubview: subcell];
        }
        
    }
    
    return cell;
}

-(void) awakeFromNib {
    if (!_delegate) return ;
    
    NSUInteger toolbarHeight = 44; 
    
    NSInteger hcells = [_delegate numberOfColumnsInScheduleView:self];
    NSInteger vcells = [_delegate numberOfRowsInScheduleView:self];
    
    NSInteger vflat = 0;
    for (NSUInteger i = 0; i < vcells; i++) {
        vflat += [_delegate scheduleView:self numberOfCellsInRow:i];
    }
    
    CGFloat hpadding = 10.0f;
    CGFloat vpadding = 10.0f;
    CGFloat width = (self.frame.size.width - (hcells+1)*hpadding) / hcells;
    CGFloat height = (self.frame.size.height - toolbarHeight - (vflat+1)*vpadding) / vflat; 
    
    CGPoint offset = CGPointMake(hpadding, toolbarHeight + vpadding);
    
    CGFloat dHeight;
    CGFloat dWidth;
    for (NSUInteger row = 0; row < vcells; row++) {
        
        NSUInteger column = [_delegate scheduleView:self numberOfColumnsInRow:row];
        NSUInteger cells = [_delegate scheduleView:self numberOfCellsInRow:row];

        dHeight = (height + (cells > 1 ? vpadding : 0)) * cells; 
        
        for (int i = 0; i < column; i++) {        
            UIView* cell = [self createCellWithFrame:CGRectMake(offset.x, offset.y, width, dHeight) 
                                                       forRow:row 
                                                     inColumn:i 
                                             andNumberOfCells: cells];
            
            [self addSubview:cell];
            
            offset = CGPointMake(offset.x + hpadding + width, offset.y);
        }
        
        if (row < vcells - 1) {
            NSUInteger nColumns = [_delegate scheduleView:self numberOfColumnsInRow:row+1];
            
            dWidth = nColumns * width + ((nColumns-1) * hpadding);
            dWidth = (self.frame.size.width - dWidth) * 0.5f;            
            
            offset = CGPointMake(dWidth, offset.y + vpadding + dHeight);
        }
    }    
}


@end
